<?php
/**
 * @link http://www.yiiframework.com/
 * @copyright Copyright (c) 2008 Yii Software LLC
 * @license http://www.yiiframework.com/license/
 */

namespace backend\assets;

use yii\web\AssetBundle;

class AppAsset extends AssetBundle
{
    public $basePath = '@webroot';
    public $baseUrl = '@web';
    public $css = [];
    public $js = [
        'js/datatables.min.js',
        'js/dataTables.bootstrap.min.js',
        'js/dataTables-select.min.js',
        'js/moment.min.js',
        'js/bootstrap.min.js',
        'js/bootstrap-select.min.js',
        //'js/bootstrap-slider.min.js',
        'js/jasny-bootstrap.min.js',
        'js/jquery.history.min.js',
        'js/chartist.min.js',
        'js/chartist-plugin-legend.min.js',
        'js/chartist-plugin-tooltip.min.js',
        'js/jquery.noty.packaged.min.js',
        'js/bowser.min.js',
        'https://checkout.stripe.com/checkout.js',
        'js/playSound.js'
    ];
    public $depends = [
        'yii\web\JqueryAsset',
        'yii\validators\ValidationAsset',
        'yii\jui\JuiAsset',
        'yii\widgets\ActiveFormAsset',
        'yii\grid\GridViewAsset',
        'yii\widgets\PjaxAsset',
        'dosamigos\tinymce\TinyMceAsset',
        'dosamigos\datetimepicker\DateTimePickerAsset',
        'dosamigos\datepicker\DatePickerAsset',
        'dosamigos\typeahead\TypeAheadPluginAsset',
        'yii2fullcalendar\CoreAsset'
    ];

    public function init() {
        parent::init();
        $this->css[] = "css/style.css";
        $this->js[] = "js/const.js";
        $this->js[] = "js/main.js?v=20191231";
        $this->js[] = "js/functions.js";
    }
}
