<?php

namespace backend\components;


class MandrillHelper
{
    /**
     * @param string $templateName
     * @param string $subject
     * @param array $mergeVars
     * @param array|string $to
     * @param array $attachments
     * @param array|string|null $replyTo
     * @return bool
     */
    public static function sendEmail($templateName, $subject, $mergeVars, $to, $attachments = array(), $replyTo = null)
    {
        if (empty(\Yii::$app->params['mandrill']['key'])) {
            throw new \InvalidArgumentException('Mandrill not configured properly.');
        }
        $mandrill = new \Mandrill(\Yii::$app->params['mandrill']['key']);

        if (is_array($to)) {
            $toEmail = key($to);
            $toName = $to[$toEmail];
        }
        else {
            $toEmail = $to;
            $toName = null;
        }
        $params = [
            'subject' => $subject,
            'to' => [
                [
                    'email' => $toEmail,
                    'type' => 'to'
                ]
            ],
            'merge_language' => 'handlebars',
            'global_merge_vars' => []
        ];
        if ($toName) {
            $params['to'][0]['name'] = $toName;
        }
        // reply to
        if (!empty($replyTo)) {
            if (is_array($replyTo)) {
                $replyToEmail = key($replyTo);
                $replyToName = $replyTo[$replyToEmail];
                $params['headers']['Reply-To'] = "{$replyToName} <{$replyToEmail}>";
            }
            else {
                $params['headers']['Reply-To'] = $replyTo;
            }
        }
        // merge vars
        foreach ($mergeVars as $key => $value) {
            $params['global_merge_vars'][] = [
                'name' => $key,
                'content' => $value
            ];
        }
        // attachments
        if (!empty($attachments)) {
            foreach ($attachments as $name => $content) {
                $params['attachments'][] = [
                    'type' => MailHelper::getMimeType($name),
                    'name' => $name,
                    'content' => base64_encode($content)
                ];
            }
        }
        $res = $mandrill->messages->sendTemplate($templateName, [], $params);

        if (!empty($res) && count($res) > 0) {
            return !empty($res[0]['status']) && $res[0]['status'] == 'sent' ?
                true : false;
        }
        return false;
    }
}