<?php

namespace backend\components;

use ruskid\stripe\StripeCheckoutCustom;
use Yii;
use yii\helpers\Html;
use yii\web\JsExpression;


class StripeCheckoutExtended extends StripeCheckoutCustom
{
    private static $handlerRegistered = false;

    /**
     * Will show the Stripe's simple form modal
     */
    public function run() {
        $this->registerScripts();
        echo $this->generateButton();
    }

    /**
     * Will register the scripts.
     */
    private function registerScripts() {
        $view = $this->getView();

        $view->registerJsFile($this->stripeJs, ['position' => \yii\web\View::POS_END]);

        if (!self::$handlerRegistered) {
            $js = "var handler = StripeCheckout.configure({
                key: '" . Yii::$app->stripe->publicKey . "'
            });";
            $view->registerJs($js);
            $js = 'jQuery("window").on("popstate", function(e) {
                handler.close();
            });';
            $view->registerJs($js);

            self::$handlerRegistered = true;
        }

        $userEmail = is_string($this->userEmail) ?
            '"' . $this->userEmail . '"' : $this->userEmail;
        $js = 'jQuery("#' . $this->buttonOptions['id'] . '").on("click", function(e) {
                    handler.open({
                        name: "' . $this->name . '",
                        description: ' . (is_string($this->description) ? '"' . $this->description . '"' : $this->description) . ',
                        amount: ' . $this->amount . ',
                        image: "' . $this->image . '",
                        currency: "' . $this->currency . '",
                        panelLabel: "' . $this->panelLabel . '",
                        zipCode: "' . $this->validateZipCode . '",
                        email: ' . $userEmail . ',
                        allowRememberMe: "' . $this->allowRemember . '",
                        token: ' . $this->tokenFunction . ',
                        opened: ' . $this->openedFunction . ',
                        closed: ' . $this->closedFunction . '
                    });
                    e.preventDefault();
         });';
        $view->registerJs($js);
    }

    /**
     * Will generate the pay button
     * @return string
     */
    private function generateButton() {
        return Html::tag('button', $this->encodeLabel ? Html::encode($this->label) : $this->label, $this->buttonOptions);
    }
}