<?php

namespace backend\components\helpers;

use yii\base\Component;


class JsonTools extends Component
{
    public static function formErrorMessage($form)
    {
        $errors = array();
        foreach ($form->getErrors() as $e) {
            $errors[] = $e[0];
        }
        $errorsText = implode('<br>', $errors);
        return json_encode([
            'status' => 'error',
            'message' => $errorsText
        ]);
    }

    public static function successMessage($text)
    {
        return json_encode([
            'status' => 'success',
            'message' => $text
        ]);
    }

    public static function redirectMessage($newUrl, $text)
    {
        return json_encode([
            'status' => 'redirect',
            'url' => $newUrl,
            'message' => $text
        ]);
    }

    public static function errorMessage($text)
    {
        return json_encode([
            'status' => 'error',
            'message' => $text
        ]);
    }
}
