<?php

namespace backend\components\helpers;

use Yii;
use yii\base\Component;


class Password extends Component
{
    public $salt;
    public $password;
    public $hash;


    public function __construct($password = false)
    {
        if ($password) {
            $this->password = $password;
            $this->generate();
        }
    }

    public function generateRandom()
    {
        $this->password = Yii::$app->security->generateRandomString(8);
        $this->salt = Yii::$app->security->generateRandomString(12);
        $this->hash = Yii::$app->security->generatePasswordHash($this->password . strrev($this->salt));
        return true;
    }

    public function generateFromPassword($password)
    {

        $this->password = $password;
        $this->salt = Yii::$app->security->generateRandomString(12);
        $this->hash = Yii::$app->security->generatePasswordHash($this->password . strrev($this->salt));
        return true;
    }

    public function generate()
    {
        $this->salt = Yii::$app->security->generateRandomString(12);
        $this->hash = Yii::$app->security->generatePasswordHash($this->password . strrev($this->salt));
        return true;
    }

    public function getPassword()
    {
        return $this->password;
    }

    public function setPassword($password)
    {
        $this->password = $password;
    }

    public function getSalt()
    {
        return $this->salt;
    }

    public function getHash()
    {
        return $this->hash;
    }
}
