<?php

namespace backend\components\helpers;

use yii\base\Component;
use backend\models\db\UserPlan;
use yii\helpers\Url;


class Subscription extends Component
{
    public $userId;


    public function __construct($userId = false)
    {
        if ($userId) {
            $this->setUserId($userId);
        }
    }


    public function setUserId($userId)
    {
        $this->userId = $userId;
    }


    public function hasValidSubscription($userId = false)
    {
        if ($userId) {
            $this->setUserId($userId);
        }

        $userPlan = $this->getCurrentSubscription($this->userId);
        if ($userPlan === null) {
            return false;
        }

        return !$userPlan->getIsExpired();
    }

    /**
     * @param bool $userId
     * @return UserPlan
     */
    public function getCurrentSubscription($userId = null)
    {
        if ($userId) {
            $this->setUserId($userId);
        }

        return UserPlan::getActivePlan($userId);
    }

    /**
     * @param UserPlan $userPlan
     * @return string Info for user about what will happen after this plan expires
     */
    public static function getRecurrenceEndInfo(UserPlan $userPlan)
    {
        switch ($userPlan->getNextAction()) {
            case UserPlan::CHANGE_PLAN:
                return 'Plan Change';
            case UserPlan::EXPIRED:
                return 'Expired';
            default:
                return 'Next Bill';
        }
        /*default: // no plan cancellation for now
            return 'Expiration';*/
    }

    public static function getSubscriptionActionInfo(UserPlan $userPlan)
    {
        if ($userPlan->getIsExpired()) {
            $start = date('Y-m-d', strtotime($userPlan->start_time));
            $end = date('Y-m-d', $userPlan->getExpirationTime());
            if ($end <= $start) {
                return '<span class="text-warning">Subscription Pending...</span>';
            }
            else {
                return '<span class="text-danger">Subscription Expired</span>';
            }
        }
        elseif ($userPlan->is_cancelled) {
            return '<span class="text-danger">Subscription Cancelled</span>';
        }
        else {
            return '<a href="#" class="btn btn-danger open-modal" data-modal-url="' .
                        Url::toRoute(['/subscription/cancel']) .
                    '">Cancel Current Subscription</a>';
        }
    }

}
