<?php

namespace backend\components\validators;

use Yii;
use yii\validators\Validator;
use backend\components\helpers\Formatter;

class Currency extends Validator
{
    public $min;

    /**
     * Check whether date is valid.
     * @param string $attribute
     */
    public function validateAttribute($model, $attribute)
    {
        $cleanVal = Formatter::currencyToDecimal($model->{$attribute});
        $formattedVal = Formatter::currency($cleanVal, 'none');
        $formattedCleanVal = Formatter::currencyToDecimal($formattedVal);

        // currency format validation
        if ($cleanVal != $formattedCleanVal) {
            $userMeta = Yii::$app->session->get('userMeta');
            $currencyFormat = isset($userMeta['currency_format']) ?
                $userMeta['currency_format'] : Yii::$app->params['defaultCurrencyFormat'];
            $format = \backend\models\db\Currency::CURRENCY_FORMATS[$currencyFormat];
            $this->addError($model, $attribute, 'Invalid currency format. It should be ' . $format);
        }

        // minimum value validation
        if ($this->min !== null) {
            if ($model->{$attribute} < $this->min) {
                $this->addError($model, $attribute, 'Minimal value required is ' . $this->min);
            }
        }
    }
}
