<?php

namespace backend\components\validators;

use backend\models\db\Eoms;
use yii\validators\Validator;
use backend\components\helpers\Formatter;

class DateStart extends Validator
{
    public $fieldName;

    /**
     * Check whether date is valid.
     * @param string $attribute
     */
    public function validateAttribute($model, $attribute)
    {
        $budgetId = $model->budget_id;
        $time = strtotime($model->date);
        if ($this->fieldName != null) {
            $fieldNameStr = ' for ' . $this->fieldName;
        }
        else {
            $fieldNameStr = '';
        }
        $eomsExists = Eoms::find()
            ->where([
                'budget_id' => $budgetId,
                'month'     => date('n', $time),
                'year'      => date('Y', $time),
                'submitted' => 1
            ])
            ->exists();

        // EoMS already submitted for this month
        if ($eomsExists) {
            $latestEoms = Eoms::find()
                ->where([
                    'budget_id' => $budgetId,
                    'submitted' => 1
                ])
                ->orderBy('year DESC, month DESC')
                ->one();
            $this->addError($model, $attribute, 'Invalid start date' . $fieldNameStr . ', first valid date is ' . Formatter::date(
                date('Y-m-01', strtotime('+1 month', strtotime("{$latestEoms->year}-{$latestEoms->month}-20")))
            ) . '.');
        }
    }
}
