<?php
$params = array_merge(
    require(__DIR__ . '/../../common/config/params.php'),
    require(__DIR__ . '/../../common/config/params-local.php'),
    require(__DIR__ . '/params.php'),
    require(__DIR__ . '/params-local.php'),
    require(__DIR__ . '/video-tutorial.php')
);

return [
    'id' => 'app-backend',
    'basePath' => dirname(__DIR__),
    'controllerNamespace' => 'backend\controllers',
    'bootstrap' => ['log'],
    'modules' => [
        'admin' => [
            'class' => 'backend\modules\admin\Module',
        ],
        'api' => [
            'class' => 'backend\modules\api\Module',
        ],
    ],
    'components' => [
        'assetManager' => [
            'linkAssets' => true,
            'bundles' => [
                'yii\bootstrap\BootstrapAsset' => [
                    'sourcePath' => null,
                    'css' => [],//['css/style.css'],
                ],
                'yii\bootstrap\BootstrapPluginAsset' => [
                    'sourcePath' => null,
                    'js' => [],//['js/bootstrap.js'],
                ],
                'yii\web\JqueryAsset' => [
                    'js' => ['jquery.min.js']
                ],
                'dosamigos\tinymce\TinyMceAsset' => [
                    'css' => [
                        'skins/lightgray/skin.min.css',
                        'skins/lightgray/content.min.css'
                    ],
                    'js' => [
                        YII_DEBUG ? 'tinymce.js' : 'tinymce.min.js',
                        YII_DEBUG ? 'themes/modern/theme.js' : 'themes/modern/theme.min.js'
                    ]
                ]
            ],
        ],
        'errorHandler' => [
            'errorAction' => 'site/error',
        ],
        'request' => [
            'csrfParam' => '_backend_csrf',
            'cookieValidationKey' => 'tPydV7pjG1bnqPEH1Ejtq_Jo6KHEUSwpx',
            'parsers' => [
                'application/json' => 'yii\web\JsonParser',
            ]
        ],
        'user' => [
            'class' => 'backend\components\User',
            'identityClass' => 'common\models\User',
            'loginUrl' => ['/site/login'],
            'enableAutoLogin' => true,
        ]
    ],
    'params' => $params,
];
