<?php

namespace backend\controllers;

use Yii;

use yii\filters\AccessControl;

use backend\components\CustomController;

use backend\models\db\Account;
use backend\models\db\AccountBalance;
use backend\models\db\Eoms;

/**
 * Account balances controller
 */
class AccountBalancesController extends CustomController {

    public $enableCsrfValidation = false;

    public function behaviors() {

        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => [
                            'account-balances-graph-data',
                        ],
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ]
        ];

    }


    /**
     * Get data for balances graph.
     */
    public function actionAccountBalancesGraphData() {

        $accountId = Yii::$app->getRequest()->getQueryParam('account_id', false);

        if (!is_numeric($accountId)) {

            return $this->accessError();

        }

        $account = Account::findOne($accountId);

        if (!Yii::$app->user->can('accessBudget', ['budgetId' => $account->budget_id])) {

            return $this->accessError();

        }

        $year = Yii::$app->getRequest()->getQueryParam('year', false);

        if (!$year || !is_numeric($year)) {

            return $this->accessError();

        }

        $initTime = $time = strtotime("$year-1-1");

        $balances = AccountBalance::find()
            ->select(AccountBalance::tableName() . '.*, ' . Eoms::tableName() . '.year, ' . Eoms::tableName() . '.month')
            ->joinWith('eoms')
            ->where([
                'account_id' => $accountId,
                Eoms::tableName() . '.year' => $year
            ])
            ->orderBy('month asc')
            ->all();

        $firstBalance = AccountBalance::find()
            ->select(AccountBalance::tableName() . '.*, ' . Eoms::tableName() . '.year, ' . Eoms::tableName() . '.month')
            ->joinWith('eoms')
            ->where([
                'account_id' => $accountId,
                'year' => $year
            ])
            ->orderBy('id ASC')
            ->one();

        if ($firstBalance) {

            $firstBalanceYearTime = strtotime($firstBalance->year . '-1-1');

        }

        // return balances if any found
        if (isset($firstBalanceYearTime) && ($initTime >= $firstBalanceYearTime)) {

            $monthsBalancesKeyed = [];
            $minBalance = 0;
            $maxBalance = 0;
            foreach ($balances as $b) {

                $monthsBalancesKeyed[date('n', strtotime($b->year . '-' . $b->month . '-1'))] = $b->balance;

                if ($b->balance < $minBalance) {

                    $minBalance = $b->balance;

                }

                if ($b->balance > $maxBalance) {

                    $maxBalance = $b->balance;

                }

            }

            $monthsBalances = [];
            for ($i=1; $i<=12; $i++) {

                $monthsBalances[] = (isset($monthsBalancesKeyed[$i])) ? $monthsBalancesKeyed[$i] : null;

            }

            $response = [
                'title' => $year,
                'year' => $year,
                'series' => [
                    [
                        'name' => 'Adjustment',
                        'data' => $monthsBalances
                    ]
                ],
                'labels' => ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
                'min' => $minBalance,
                'max' => $maxBalance
            ];

        }
        else {

            $response = false;

        }

        return json_encode($response);
        die();


    }



}
