<?php

namespace backend\controllers;

use backend\components\CustomController;
use backend\models\db\FaqCategory;
use yii\filters\AccessControl;

/**
 * Lessons controller
 */
class LessonsController extends CustomController
{

    public $enableCsrfValidation = false;

    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => [
                            'index', 'page'
                        ],
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ]
        ];
    }

    /**
     * Show accounts
     */
    public function actionIndex()
    {
        $this->view->title = 'Lessons';

        return $this->render('index', [
            'title' => 'Lessons'
        ]);
    }

    public function actionPage($group, $page)
    {
        $fullLoad = \Yii::$app->getRequest()->getQueryParam('full_load', false); // whether to load all page content

        if ($this->pageLoadRequest || $fullLoad) {
            return $this->render('page', [
                'group' => $group,
                'page' => $page
            ]);
        }
        else {
            return $this->render('page-content', [
                'group' => $group,
                'page' => $page
            ]);
        }
    }
}
