<?php

namespace backend\controllers;

use backend\models\db\FaqQuestion;
use backend\models\db\Jar;
use backend\models\db\Page;
use backend\models\db\SearchLog;
use Yii;
use backend\components\CustomController;
use yii\data\ActiveDataProvider;

class SearchController extends CustomController
{
    public function actionResults($q = '')
    {
        $displayResults = !empty($q);

        if ($displayResults && !Yii::$app->user->isGuest) {
            SearchLog::saveQuery($q);
        }

        $faqQuery = FaqQuestion::find()
            ->andWhere(['archived' => 0])
            ->andFilterWhere(['or', ['like', 'title', $q], ['like', 'description', $q]]);
        $faqs = new ActiveDataProvider([
            'query' => $faqQuery,
            'pagination' => [
                'pageSize' => Yii::$app->params['searchResultsPageSize'],
                'pageParam' => 'faq-page'
            ]
        ]);

        return $this->render('results', [
            'faqs' => $faqs,
            'displayResults' => $displayResults,
            'queryString' => $q,
        ]);
    }
}
