<?php

namespace backend\controllers;

use Yii;

use yii\filters\AccessControl;
use yii\web\Controller;

use backend\models\db\Debt;
use backend\models\db\DebtChange;
use backend\models\db\DebtEnd;
use backend\models\db\DebtPayment;
use backend\models\db\Expense;
use backend\models\db\ExpenseChange;
use backend\models\db\ExpenseStart;
use backend\models\db\Income;
use backend\models\db\IncomeChange;
use backend\models\db\IncomeEnd;
use backend\models\db\IncomeTransaction;
use backend\models\db\Transaction;
use backend\models\db\Transfer;
use backend\models\db\TransferChange;
use backend\models\db\TransferEnd;
use backend\models\db\TransferEvent;

use backend\models\form\PopulateDb;


/**
 * Transactions controller
 */
class TestController extends Controller {

    public function init() {

        $this->layout = 'pre-login';

        parent::init();

    }

    public function behaviors() {

        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => [
                            'populate-db',
                            'run-data-scripts',
                            'dirty'
                        ],
                        'allow' => true,
                        'roles' => ['superadmin'],
                    ],
                ],
            ]
        ];

    }

    /**
     * Just run the scripts in the console/data controller
     */
    public function actionRunDataScripts() {

        chdir("../../");

        $response = array();
        $res = exec("php yii data 2>&1", $response);
        echo implode("\r\n",$response);

    }


    /**
     * Helps populate the data with usable records - test cases for conditions
     */
    public function actionPopulateDb() {

        $message = '';
        $form = new PopulateDb();

        if (Yii::$app->request->isPost && $form->load(Yii::$app->request->post())) {

            if ($form->update_expenses == 1) {

                $this->_insertExpenses($form);

            }

            if ($form->update_debts == 1) {

                $this->_insertDebts($form);

            }

            if ($form->update_incomes == 1) {

                $this->_insertIncomes($form);

            }

            if ($form->update_transfers == 1) {

                $this->_insertTransfers($form);

            }

            $message = 'Done!';

        }
        else {

            return $this->render('populate-db', [
                'message' => $message,
                'formModel' => $form
            ]);

        }

    }


    private function _insertTransfers($form) {

        $todayDate = date("$form->year-$form->month-$form->day");
        $todayTime = strtotime($todayDate);

        $transferRecords = [
            [
                'date' => $todayDate,
                'frequency' => 'one-time',
                'shouldGenerate' => false
            ],
            [
                'date' =>$todayDate,
                'start_time' => strtotime('-1 DAYS', $todayTime),
                'frequency' => 'one-time',
                'shouldGenerate' => true
            ],
            [
                'date' => date('Y-m-d', strtotime('-1 WEEKS', $todayTime)),
                'frequency' => 'weekly',
                'shouldGenerate' => true
            ],
            [
                'date' => date('Y-m-d', strtotime('+1 WEEKS', $todayTime)),
                'frequency' => 'daily',
                'shouldGenerate' => false
            ],
            [
                'date' => date('Y-m-d', strtotime('-1 WEEKS', $todayTime)),
                'frequency' => 'daily',
                'end_date' => date('Y-m-d', strtotime('-2 DAYS', $todayTime)),
                'shouldGenerate' => false
            ],
            [
                'date' => date('Y-m-d', strtotime('-1 WEEKS', $todayTime)),
                'frequency' => 'weekly',
                'archived' => 1,
                'shouldGenerate' => false
            ]
        ];

        // delete transfers
        $transfers = Transfer::findAll(['budget_id' => $form->budget_id]);
        Transfer::deleteAll(['budget_id' => $form->budget_id]);

        $transferIds = [];
        foreach ($transfers as $t) {

            $transferIds[] = $t->id;

        }
        TransferEvent::deleteAll(['IN', 'transfer_id', $transferIds]);

        $count = 0;
        foreach ($transferRecords as $t) {

            // insert transfer
            $count++;
            $transfer = new Transfer();
            $transfer->setAttributes([
                'budget_id' => $form->budget_id,
                'account_from_id' => $form->account_id,
                'account_to_id' => $form->account_2_id,
                'name' => 'T' . $count . (($t['shouldGenerate']) ? '/y' : '/n'),
                'date' => $t['date'],
                'frequency' => $t['frequency'],
                'amount' => rand(1, 6) * 5
            ]);

            if (isset($t['archived'])) {

                $transfer->archived = $t['archived'];

            }

            $transfer->save();
            $errors = $transfer->getErrors();
            if (count($errors)) {

                var_dump($errors);

            }

            // insert transfer change
            $transferChange = new TransferChange();
            $transferChange->setAttributes([
                'transfer_id' => $transfer->id,
                'type' => 'C',
            ]);

            if (isset($t['start_time'])) {

                $transferChange->time = $t['start_time'];

            }

            $transferChange->save();
            $errors = $transferChange->getErrors();
            if (count($errors)) {

                var_dump($errors);

            }

            // insert transfer end
            if (isset($t['end_date'])) {

                $transferEnd = new TransferEnd();
                $transferEnd->setAttributes([
                    'date' => $t['end_date'],
                    'transfer_id' => $transfer->id
                ]);
                $transferEnd->save();
                $errors = $transferEnd->getErrors();
                if (count($errors)) {

                    var_dump($errors);

                }

            }

        }

    }


    private function _insertIncomes($form) {

        $todayDate = date("$form->year-$form->month-$form->day");
        $todayTime = strtotime($todayDate);

        $incomeRecords = [
            [
                'date' => $todayDate,
                'frequency' => 'one-time',
                'shouldGenerate' => false
            ],
            [
                'date' => $todayDate,
                'start_time' => strtotime('-1 DAYS', $todayTime),
                'frequency' => 'one-time',
                'shouldGenerate' => true
            ],
            [
                'date' => date('Y-m-d', strtotime('-1 WEEKS', $todayTime)),
                'frequency' => 'weekly',
                'shouldGenerate' => true
            ],
            [
                'date' => date('Y-m-d', strtotime('+1 WEEKS', $todayTime)),
                'frequency' => 'daily',
                'shouldGenerate' => false
            ],
            [
                'date' => date('Y-m-d', strtotime('-1 WEEKS', $todayTime)),
                'frequency' => 'daily',
                'end_date' => date('Y-m-d', strtotime('-2 DAYS')),
                'shouldGenerate' => false
            ],
            [
                'date' => date('Y-m-d', strtotime('-1 WEEKS', $todayTime)),
                'frequency' => 'weekly',
                'archived' => 1,
                'shouldGenerate' => false
            ]
        ];

        // delete incomes
        $incomes = Income::findAll(['budget_id' => $form->budget_id]);
        Income::deleteAll(['budget_id' => $form->budget_id]);

        $incomeIds = [];
        foreach ($incomes as $d) {

            $incomeIds[] = $d->id;

        }
        IncomeTransaction::deleteAll(['IN', 'income_id', $incomeIds]);

        $count = 0;
        foreach ($incomeRecords as $i) {

            // insert income
            $count++;
            $income = new Income();
            $income->setAttributes([
                'budget_id' => $form->budget_id,
                'account_id' => $form->account_id,
                'name' => 'I' . $count . (($i['shouldGenerate']) ? '/y' : '/n'),
                'date' => $i['date'],
                'frequency' => $i['frequency'],
                'amount' => rand(10, 55) * 5
            ]);

            if (isset($i['archived'])) {

                $income->archived = $i['archived'];

            }

            $income->save();
            $errors = $income->getErrors();
            if (count($errors)) {

                var_dump($errors);

            }

            // insert income change
            $incomeChange = new IncomeChange();
            $incomeChange->setAttributes([
                'income_id' => $income->id,
                'type' => 'C',
            ]);

            if (isset($i['start_time'])) {

                $incomeChange->time = $i['start_time'];

            }

            $incomeChange->save();
            $errors = $incomeChange->getErrors();
            if (count($errors)) {

                var_dump($errors);

            }

            // insert income end
            if (isset($i['end_date'])) {

                $incomeEnd = new IncomeEnd();
                $incomeEnd->setAttributes([
                    'date' => $i['end_date'],
                    'income_id' => $income->id
                ]);
                $incomeEnd->save();
                $errors = $incomeEnd->getErrors();
                if (count($errors)) {

                    var_dump($errors);

                }

            }

        }

    }


    private function _insertDebts($form) {

        $todayDate = date("$form->year-$form->month-$form->day");
        $todayTime = strtotime($todayDate);

        $debtRecords = [
            [
                'date' => date('Y-m-d', strtotime('-1 DAYS', $todayTime)),
                'frequency' => 'daily',
                'shouldGenerate' => true,
                'shouldGenerateType' => 1
            ],
            [
                'date' => $todayDate,
                'frequency' => 'daily',
                'shouldGenerate' => true,
                'shouldGenerateType' => 1
            ],
            [
                'date' => date('Y-m-d', strtotime('+5 DAYS', $todayTime)),
                'frequency' => 'daily',
                'shouldGenerate' => false
            ],
            [
                'date' => date('Y-m-d', strtotime('-1 MONTHS', $todayTime)),
                'frequency' => 'semi-annually',
                'shouldGenerate' => true,
                'shouldGenerateType' => 2
            ],
            [
                'date' => date('Y-m-d', strtotime('-1 MONTHS', $todayTime)),
                'interest_free_end_date' => date('Y-m-d', strtotime('+15 DAYS', $todayTime)),
                'frequency' => 'semi-annually',
                'shouldGenerate' => false
            ],
            [
                'date' => date('Y-m-d', strtotime('-1 DAYS', $todayTime)),
                'frequency' => 'daily',
                'archived' => 1,
                'shouldGenerate' => false
            ],
            [
                'date' => date('Y-m-d', strtotime('-50 DAYS', $todayTime)),
                'end_date' => date('Y-m-d', strtotime('-30 DAYS', $todayTime)),
                'frequency' => 'daily',
                'shouldGenerate' => false
            ],
            [
                'date' => date('Y-m-d', strtotime('-1 MONTH', $todayTime)),
                'end_date' => date('Y-m-d', strtotime('-15 DAYS', $todayTime)),
                'frequency' => 'monthly',
                'shouldGenerate' => false
            ],
            [
                'date' => $todayDate,
                'frequency' => 'monthly',
                'shouldGenerate' => true,
                'shouldGenerateType' => 1
            ],
            [
                'date' => $todayDate,
                'frequency' => 'one-time',
                'shouldGenerate' => false
            ]
        ];


        // delete debts
        $debts = Debt::findAll(['budget_id' => $form->budget_id]);
        Debt::deleteAll(['budget_id' => $form->budget_id]);

        $debtIds = [];
        foreach ($debts as $d) {

            $debtIds[] = $d->id;

        }
        DebtPayment::deleteAll(['IN', 'debt_id', $debtIds]);

        $count = 0;
        foreach ($debtRecords as $d) {

            // insert debt
            $count++;
            $debt = new Debt();
            $debt->setAttributes([
                'budget_id' => $form->budget_id,
                'debt_type_id' => 1,
                'account_id' => $form->account_id,
                'name' => 'D' . $count . (($d['shouldGenerate']) ? '/y' . (($d['shouldGenerateType'] == 1) ? ' DP' : ' IP') : '/n'),
                'interest' => rand(1,5),
                'date' => $d['date'],
                'frequency' => $d['frequency'],
                'payment' => rand(3, 30) * 5,
                'amount' => rand(1, 20) * 10,
                'tax_deductible' => $count % 2
            ]);

            if (isset($d['interest_free_end_date'])) {

                $debt->interest_free_end_date = $d['interest_free_end_date'];

            }

            if (isset($d['archived'])) {

                $debt->archived = $d['archived'];

            }

            $debt->save();
            $errors = $debt->getErrors();
            if (count($errors)) {

                var_dump($errors);

            }

            // insert debt change
            $debtChange = new DebtChange();
            $debtChange->setAttributes([
                'debt_id' => $debt->id,
                'type' => 'C'
            ]);

            $debtChange->save();
            $errors = $debtChange->getErrors();
            if (count($errors)) {

                var_dump($errors);

            }

            // insert debt end
            if (isset($d['end_date'])) {

                $debtEnd = new DebtEnd();
                $debtEnd->setAttributes([
                    'date' => $d['end_date'],
                    'debt_id' => $debt->id
                ]);
                $debtEnd->save();
                $errors = $debtEnd->getErrors();
                if (count($errors)) {

                    var_dump($errors);

                }

            }

        }

    }


    private function _insertExpenses($form) {

        $todayDate = date("$form->year-$form->month-$form->day");
        $todayTime = strtotime($todayDate);

        // insert expenses into db
        $expenseRecords = [
            [
                'date' => $todayDate,
                'frequency' => 'daily',
                'generateTransactions' => '1',
                'shouldGenerate' => true
            ],
            [
                'date' => date('Y-m-d', strtotime('-1 DAYS', $todayTime)),
                'frequency' => 'daily',
                'generateTransactions' => '1',
                'shouldGenerate' => true
            ],
            [
                'date' => date('Y-m-d', strtotime('-1 WEEKS', $todayTime)),
                'frequency' => 'weekly',
                'generateTransactions' => '1',
                'shouldGenerate' => true
            ],
            [
                'date' => date('Y-m-d', strtotime('-2 WEEKS', $todayTime)),
                'frequency' => 'fortnightly',
                'generateTransactions' => '1',
                'shouldGenerate' => true
            ],
            [
                'date' => date('Y-m-d', strtotime('-1 MONTH', $todayTime)),
                'frequency' => 'monthly',
                'generateTransactions' => '1',
                'shouldGenerate' => true
            ],
            [
                'date' => date('Y-m-d', strtotime('-3 MONTHS', $todayTime)),
                'frequency' => 'quarterly',
                'generateTransactions' => '1',
                'shouldGenerate' => true
            ],
            [
                'date' => date('Y-m-d', strtotime('-6 MONTHS', $todayTime)),
                'frequency' => 'semi-annually',
                'generateTransactions' => '1',
                'shouldGenerate' => true
            ],
            [
                'date' => date('Y-m-d', strtotime('-1 YEARS', $todayTime)),
                'frequency' => 'annually',
                'generateTransactions' => '1',
                'shouldGenerate' => true
            ],
            [
                'date' => date('Y-m-d', strtotime('-1 DAYS', $todayTime)),
                'frequency' => 'daily',
                'generateTransactions' => '0',
                'shouldGenerate' => false
            ],
            [
                'date' => date('Y-m-d', strtotime('+1 WEEKS', $todayTime)),
                'frequency' => 'daily',
                'generateTransactions' => '1',
                'shouldGenerate' => false
            ],
            [
                'date' => date('Y-m-d', strtotime('-1 WEEKS', $todayTime)),
                'frequency' => 'daily',
                'generateTransactions' => '1',
                'archived' => 1,
                'shouldGenerate' => false
            ],
            [
                'date' => $todayDate,
                'start_date' => $todayDate,
                'frequency' => 'one-time',
                'generateTransactions' => '0',
                'shouldGenerate' => false
            ],
            [
                'date' => $todayDate,
                'start_date' => date('Y-m-d', strtotime('-1 WEEKS', $todayTime)),
                'frequency' => 'one-time',
                'generateTransactions' => '0',
                'shouldGenerate' => true
            ],
            [
                'date' => date('Y-m-d', strtotime('+1 WEEKS', $todayTime)),
                'start_date' => date('Y-m-d', strtotime('-1 MONTHS', $todayTime)),
                'frequency' => 'one-time',
                'generateTransactions' => '0',
                'shouldGenerate' => false
            ],
            [
                'date' => date('Y-m-d', strtotime('+1 MONTHS', $todayTime)),
                'start_date' => date('Y-m-d', strtotime('-1 MONTHS', $todayTime)),
                'frequency' => 'one-time',
                'generateTransactions' => '1',
                'shouldGenerate' => true
            ],
            [
                'date' => date('Y-m-d', strtotime('+1 WEEKS', $todayTime)),
                'start_date' => date('Y-m-d', strtotime('-1 MONTHS', $todayTime)),
                'frequency' => 'one-time',
                'generateTransactions' => '1',
                'archived' => 1,
                'shouldGenerate' => true
            ]
        ];


        $expenses = Expense::findAll(['jar_id' => $form->jar_id]);
        $expenseIds = [];
        foreach ($expenses as $e) {

            $expenseIds[] = $e->id;

        }

        // delete transactions
        Transaction::deleteAll(['IN', 'expense_id', $expenseIds]);
        Expense::deleteAll(['jar_id' => $form->jar_id]);

        $count = 0;
        foreach ($expenseRecords as $e) {

            // insert expense
            $count++;
            $expense = new Expense();
            $expense->setAttributes([
                'date' => $e['date'],
                'frequency' => $e['frequency'],
                'generate_transactions' => $e['generateTransactions'],
                'name' => 'E' . $count . (($e['shouldGenerate']) ? '/y' : '/n'),
                'jar_id' => $form->jar_id,
                'account_id' => $form->account_id,
                'amount' => rand(1, 20) * 10,
                'tax_deductible' => $count % 2
            ]);

            if (isset($e['archived'])) {
                $expense->archived = $e['archived'];
            }

            $expense->save();
            $errors = $expense->getErrors();
            if (count($errors)) {

                var_dump($errors);

            }

            // insert expense change
            $expenseChange = new ExpenseChange();
            $expenseChange->setAttributes([
                'expense_id' => $expense->id,
                'type' => 'C'
            ]);
            $expenseChange->save();
            $errors = $expenseChange->getErrors();
            if (count($errors)) {

                var_dump($errors);

            }

            // insert expense start
            if (isset($e['start_date'])) {

                $expenseStart = new ExpenseStart();
                $expenseStart->setAttributes([
                    'date' => $e['start_date'],
                    'expense_id' => $expense->id
                ]);
                $expenseStart->save();
                $errors = $expenseStart->getErrors();
                if (count($errors)) {

                    var_dump($errors);

                }

            }

        }

    }


    /**
     * Forgive me Lord, for I don't have time to do stuff the proper way now...
     */
    public function actionDirty() {
        var_dump(timezone_name_from_abbr("", -4.5*3600, false));
        $calculator = new \backend\components\helpers\Calculator();

        $cases = [
            [
                '2016-7-31',
                'one-time',
                '2016-6-1',
                '2016-6-30'
            ],
            [
                '2016-1-31',
                'monthly',
                '2016-7-31'
            ],
            [
                '2016-1-31',
                'monthly',
                '2016-2-20'
            ]
        ];

        foreach ($cases as $c) {
            if (count($c) == 2)
                var_dump($calculator::nextDueDate($c[0], $c[1]));
            elseif (count($c) == 3)
                var_dump($calculator::nextDueDate($c[0], $c[1], $c[2]));
            else
                var_dump($calculator::nextDueDate($c[0], $c[1], $c[2], $c[3]));
            echo '<br>';
        }

        echo '<br>';

        $cases = [
            [
                '2016-5-31',
                'monthly',
                '2016-5-10'
            ],
            [
                '2016-10-20',
                'one-time',
                false,
                '2016-5-31'
            ]
        ];

        foreach ($cases as $c) {
            if (count($c) == 2)
                var_dump($calculator::prevDueDate($c[0], $c[1]));
            elseif (count($c) == 3)
                var_dump($calculator::prevDueDate($c[0], $c[1], $c[2]));
            else
                var_dump($calculator::prevDueDate($c[0], $c[1], $c[2], $c[3]));
            echo '<br>';
        }

    }

}
