<?php

namespace backend\models;

/**
 * Helper DB Model class that provides additional scenario for model cloning,
 * allowing all attributes to be massively assigned.
 * It's used for models that use ...Change / ...ChangeMeta for tracking changes.
 * When the "clone" scenario is set, the changes are not saved for the model.
 */
class ChangeMetaModel extends \yii\db\ActiveRecord
{
    const SCENARIO_CLONE = 'clone';

    public function scenarios()
    {
        $scenarios = parent::scenarios();
        // allow all attributes to be safe except the primary key
        $primaryKey = key($this->getPrimaryKey(true));
        // make sure we have array (it's true for composite primary keys)
        if (!is_array($primaryKey)) {
            $primaryKey = [$primaryKey];
        }
        $scenarios[self::SCENARIO_CLONE] = array_diff(array_keys($this->attributes), $primaryKey);
        return $scenarios;
    }
}
