<?php

namespace backend\models\db;


/**
 * This is the model class for table "account_changes".
 *
 * @property integer $id
 * @property integer $account_id
 * @property string $time
 * @property string $type
 * @property integer $user_id
 *
 * @property AccountChangeMeta[] $accountChangeMetas
 * @property Account $account
 * @property User $user
 */
class AccountChange extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'account_changes';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['account_id', 'user_id'], 'integer'],
            [['time'], 'safe'],
            [['type'], 'string', 'max' => 1]
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'account_id' => 'Account ID',
            'time' => 'Time',
            'type' => 'Type',
            'user_id' => 'User ID',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getAccountChangeMeta()
    {
        return $this->hasMany(AccountChangeMeta::className(), ['account_change_id' => 'id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getAccount()
    {
        return $this->hasOne(Account::className(), ['id' => 'account_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getUser()
    {
        return $this->hasOne(User::className(), ['id' => 'user_id']);
    }
}
