<?php

namespace backend\models\db;


/**
 * This is the model class for table "account_change_meta".
 *
 * @property integer $id
 * @property integer $account_change_id
 * @property string $key
 * @property string $value
 *
 * @property AccountChange $accountChange
 */
class AccountChangeMeta extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'account_change_meta';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['account_change_id'], 'integer'],
            [['key'], 'string', 'max' => 40],
            [['value'], 'string', 'max' => 45]
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'account_change_id' => 'Account Change ID',
            'key' => 'Key',
            'value' => 'Value',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getAccountChange()
    {
        return $this->hasOne(AccountChange::className(), ['id' => 'account_change_id']);
    }
}
