<?php

namespace backend\models\db;


/**
 * This is the model class for table "account_eoms_balances".
 *
 * @property integer $id
 * @property integer $account_id
 * @property integer $eoms_id
 * @property double $balance
 *
 * @property Account $account
 * @property Eoms $eoms
 */
class AccountEomsBalance extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'account_eoms_balances';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['account_id', 'balance'], 'required'],
            [['account_id', 'eoms_id'], 'integer'],
            [['balance'], 'number']
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'account_id' => 'Account ID',
            'eoms_id' => 'Eoms ID',
            'balance' => 'Balance',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getAccount()
    {
        return $this->hasOne(Account::className(), ['id' => 'account_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getEoms()
    {
        return $this->hasOne(Eoms::className(), ['id' => 'eoms_id']);
    }
}
