<?php

namespace backend\models\db;


/**
 * This is the model class for table "appointments".
 *
 * @property integer $id
 * @property string $datetime
 * @property integer $user_id
 *
 * @property AppointmentUser[] $appointmentUsers
 * @property User $user
 */
class Appointment extends \yii\db\ActiveRecord
{

    private $_daysUntil;

    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'appointments';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['datetime', 'user_id'], 'required'],
            [['datetime'], 'safe'],
            [['user_id'], 'integer']
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'datetime' => 'Datetime',
            'user_id' => 'User ID',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getAppointmentUsers()
    {
        return $this->hasMany(AppointmentUser::className(), ['appointment_id' => 'id']);
    }


    public function getAppointmentUser()
    {
        return $this->hasOne(AppointmentUser::className(), ['appointment_id' => 'id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getUser()
    {
        return $this->hasOne(User::className(), ['id' => 'user_id']);
    }


    /**
     * Create a new booking for user
     * @param integer $userId The ID of the user the booking is for.
     * @return boolean Booking success.
     */
    public function book($userId) {

        $appointmentUser = new AppointmentUser;
        $appointmentUser->setAttributes([
            'appointment_id' => $this->id,
            'user_id' => $userId
        ]);
        return $appointmentUser->save();

    }

    /**
     * Cancel an appoinments bookings.
     * @return integer|boolean Cancellation success.
     */
    public function cancelBooking() {

        $appointmentUser = AppointmentUser::findOne(['appointment_id' => $this->id]);
        return $appointmentUser->delete();

    }


    /**
     * Get the number of days remaining until the appointment is due.
     * @return integer The number of whole days left.
     */
    public function getDaysUntil() {

        if ($this->_daysUntil == null) {

            $this->_daysUntil = intval((strtotime($this->datetime) - time()) / 86400);

        }

        return $this->_daysUntil;

    }

}
