<?php

namespace backend\models\db;


/**
 * This is the model class for table "conversation_messages".
 *
 * @property integer $id
 * @property integer $conversation_id
 * @property integer $user_id
 * @property string $text
 * @property string $time
 *
 * @property ConversationMessageAttachment[] $conversationMessageAttachments
 * @property Conversation $conversation
 * @property User $user
 */
class ConversationMessage extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'conversation_messages';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['conversation_id', 'user_id'], 'integer'],
            [['text'], 'string'],
            [['time'], 'safe']
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'conversation_id' => 'Conversation ID',
            'user_id' => 'User ID',
            'text' => 'Text',
            'time' => 'Time',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getConversationMessageAttachments()
    {
        return $this->hasMany(ConversationMessageAttachment::className(), ['conversation_message_id' => 'id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getConversationMessageSeen()
    {
        return $this->hasMany(ConversationMessageSeen::className(), ['conversation_message_id' => 'id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getConversation()
    {
        return $this->hasOne(Conversation::className(), ['id' => 'conversation_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getUser()
    {
        return $this->hasOne(User::className(), ['id' => 'user_id']);
    }
}
