<?php

namespace backend\models\db;


/**
 * This is the model class for table "conversation_message_attachments".
 *
 * @property integer $id
 * @property integer $conversation_message_id
 * @property string $path
 *
 * @property ConversationMessage $conversationMessage
 */
class ConversationMessageAttachment extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'conversation_message_attachments';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['conversation_message_id'], 'integer'],
            [['path'], 'string', 'max' => 200]
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'conversation_message_id' => 'Conversation Message ID',
            'path' => 'Path',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getConversationMessage()
    {
        return $this->hasOne(ConversationMessages::className(), ['id' => 'conversation_message_id']);
    }
}
