<?php

namespace backend\models\db;

use Yii;


/**
 * This is the model class for table "currencies".
 *
 * @property integer $id
 * @property string $name
 * @property string $code
 * @property string $sign
 * @property string $position
 */
class Currency extends \yii\db\ActiveRecord
{
    const CURRENCY_FORMATS = [
        ',-.' => '123,456.78 (comma, period)',
        '.-,' => '123.456,78 (period, comma)',
        ' -.' => '123 456.78 (space, period)',
        ' -,' => '123 456,78 (space, comma)',
        '-.'  => '123456.78 (period)',
        '-,'  => '123456,78 (comma)'
    ];


    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'currencies';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['name', 'code', 'sign', 'position'], 'required'],
            [['position'], 'string'],
            [['name'], 'string', 'max' => 15],
            [['code', 'sign'], 'string', 'max' => 3]
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'name' => 'Name',
            'code' => 'Code',
            'sign' => 'Sign',
            'position' => 'Position',
        ];
    }

    /**
     * Returns currency record
     * @param null|integer $metaCurrencyId
     * @return Currency
     */
    public static function getCurrency($metaCurrencyId = null)
    {
        $currencyId = $metaCurrencyId && is_numeric($metaCurrencyId) ?
            $metaCurrencyId : Yii::$app->params['defaultCurrencyId'];
        $currency = Currency::findOne(['id' => $currencyId]);
        if (!$currency) {
            $currency = Currency::findOne(['id' => 1]);
        }
        return $currency;
    }

    /**
     * Get list of available currencies ready to feed the dropdown list
     * @return array
     */
    public static function getList()
    {
        $result = [];
        $items = Currency::find()
            ->orderBy('order ASC, name ASC')
            ->all();
        foreach ($items as $item) {
            if ($item->order < 9999) {
                $result['Popular Currencies'][$item->id] = "$item->name ($item->sign)";
            }
            else {
                $result['All Currencies'][$item->id] = "$item->name ($item->sign)";
            }
        }
        return $result;
    }

    public static function getCurrencyFormatDetails($metaCurrencyFormat = null)
    {
        $currencyFormatCode = $metaCurrencyFormat ?
            $metaCurrencyFormat : Yii::$app->params['defaultCurrencyFormat'];
        $formats = self::CURRENCY_FORMATS;
        $currencyFormat = isset($formats[$currencyFormatCode]) ?
            $currencyFormatCode : array_shift(array_keys($formats));
        $currencyFormatName = $formats[$currencyFormat];
        $formatArr = explode('-', $currencyFormat, 2);

        return [
            'thousand_separator' => $formatArr[0],
            'decimal_separator' => $formatArr[1],
            'name' => $currencyFormatName
        ];
    }
}
