<?php

namespace backend\models\db;

use Yii;


/**
 * This is the model class for table "date_formats".
 *
 * @property integer $id
 * @property string $format
 * @property string $name
 */
class DateFormat extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'date_formats';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['format', 'name'], 'required'],
            [['format'], 'string', 'max' => 12],
            [['name'], 'string', 'max' => 25]
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'format' => 'Format',
            'name' => 'Name',
        ];
    }

    /**
     * Returns date format for the selected date format record
     * @param null|integer $metaDateFormatId
     * @return string
     */
    public static function getDateFormat($metaDateFormatId = null)
    {
        $dateFormatId = $metaDateFormatId && is_numeric($metaDateFormatId) ?
            $metaDateFormatId : Yii::$app->params['defaultDateFormatId'];
        $dateFormat = DateFormat::findOne(['id' => $dateFormatId]);

        if (!$dateFormat) {

            $dateFormat = DateFormat::findOne(['id' => 1]);

        }

        return $dateFormat->format;
    }
}
