<?php

namespace backend\models\db;


/**
 * This is the model class for table "debt_changes".
 *
 * @property integer $id
 * @property integer $debt_id
 * @property string $time
 * @property string $type
 * @property integer $user_id
 *
 * @property DebtChangeMeta[] $debtChangeMetas
 * @property Debt $debt
 * @property User $user
 */
class DebtChange extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'debt_changes';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['debt_id', 'user_id'], 'integer'],
            [['time'], 'safe'],
            [['type'], 'string', 'max' => 1]
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'debt_id' => 'Debt ID',
            'time' => 'Time',
            'type' => 'Type',
            'user_id' => 'User ID',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getDebtChangeMetas()
    {
        return $this->hasMany(DebtChangeMeta::className(), ['debt_change_id' => 'id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getDebt()
    {
        return $this->hasOne(Debt::className(), ['id' => 'debt_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getUser()
    {
        return $this->hasOne(User::className(), ['id' => 'user_id']);
    }
}
