<?php

namespace backend\models\db;


/**
 * This is the model class for table "debt_change_meta".
 *
 * @property integer $id
 * @property integer $debt_change_id
 * @property string $key
 * @property string $value
 *
 * @property DebtChange $debtChange
 */
class DebtChangeMeta extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'debt_change_meta';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['debt_change_id'], 'integer'],
            [['key'], 'string', 'max' => 40],
            [['value'], 'safe']
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'debt_change_id' => 'Debt Change ID',
            'key' => 'Key',
            'value' => 'Value',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getDebtChange()
    {
        return $this->hasOne(DebtChange::className(), ['id' => 'debt_change_id']);
    }
}
