<?php

namespace backend\models\db;


/**
 * This is the model class for table "debt_payment_types".
 *
 * @property integer $id
 * @property string $name
 *
 * @property DebtPayment[] $debtPayments
 */
class DebtPaymentType extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'debt_payment_types';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['name'], 'required'],
            [['name'], 'string', 'max' => 30]
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'name' => 'Name',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getDebtPayments()
    {
        return $this->hasMany(DebtPayment::className(), ['debt_payment_type_id' => 'id']);
    }
}
