<?php

namespace backend\models\db;

use Yii;
use backend\models\ChangeMetaModel;

/**
 * This is the model class for table "expense_starts".
 *
 * @property integer $id
 * @property integer $expense_id
 * @property string $date
 *
 * @property Expense $expense
 */
class ExpenseEnd extends ChangeMetaModel
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'expense_ends';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['date', 'expense_id'], 'required'],
            [['date'], 'safe'],
            [['expense_id'], 'integer']
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'date' => 'Date',
            'expense_id' => 'Expense ID',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getExpense()
    {
        return $this->hasOne(Expense::className(), ['id' => 'expense_id']);
    }

    /**
     * @inheritdoc
     */
    public function afterSave($insert, $changedAttributes)
    {
        parent::afterSave($insert, $changedAttributes);
        if ($this->scenario == self::SCENARIO_CLONE) {
            return;
        }

        // save meta for expense pause
        if ($insert) {
            $expenseChange = new ExpenseChange();
            $expenseChange->setAttributes([
                'type'       => 'P',
                'expense_id' => $this->expense_id,
                'user_id'    => Yii::$app->user->identity->id
            ]);
            $expenseChange->save();
        }
    }

    /**
     * @inheritdoc
     */
    public function afterDelete()
    {
        parent::afterDelete();
        if ($this->scenario == self::SCENARIO_CLONE) {
            return;
        }

        // save meta for expense continuation
        $expenseChange = new ExpenseChange();
        $expenseChange->setAttributes([
            'type'       => 'K',
            'expense_id' => $this->expense_id,
            'user_id'    => Yii::$app->user->identity->id
        ]);
        $expenseChange->save();
    }
}
