<?php

namespace backend\models\db;


/**
 * This is the model class for table "income_changes".
 *
 * @property integer $id
 * @property integer $income_id
 * @property string $time
 * @property string $type
 * @property string $user_id
 *
 * @property IncomeChangeMeta[] $incomeChangeMetas
 * @property Income $income
 */
class IncomeChange extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'income_changes';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['income_id', 'user_id'], 'integer'],
            [['time'], 'safe'],
            [['type'], 'string', 'max' => 1]
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'income_id' => 'Income ID',
            'time' => 'Time',
            'type' => 'Type',
            'user_id' => 'User ID'
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getIncomeChangeMetas()
    {
        return $this->hasMany(IncomeChangeMeta::className(), ['income_change_id' => 'id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getIncome()
    {
        return $this->hasOne(Income::className(), ['id' => 'income_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getUser()
    {
        return $this->hasOne(User::className(), ['id' => 'user_id']);
    }
}
