<?php

namespace backend\models\db;


/**
 * This is the model class for table "income_change_meta".
 *
 * @property integer $id
 * @property integer $income_change_id
 * @property string $key
 * @property string $value
 *
 * @property IncomeChange $incomeChange
 */
class IncomeChangeMeta extends \yii\db\ActiveRecord
{

    public $income_id;
    public $name;
    public $time;

    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'income_change_meta';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['income_change_id'], 'integer'],
            [['key'], 'string', 'max' => 40],
            [['value'], 'safe']
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'income_change_id' => 'Income Change ID',
            'key' => 'Key',
            'value' => 'Value',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getIncomeChange()
    {
        return $this->hasOne(IncomeChange::className(), ['id' => 'income_change_id']);
    }

}
