<?php

namespace backend\models\db;

use Yii;
use backend\models\ChangeMetaModel;

/**
 * This is the model class for table "income_ends".
 *
 * @property integer $id
 * @property integer $income_id
 * @property string $date
 *
 * @property Income $income
 */
class IncomeEnd extends ChangeMetaModel
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'income_ends';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['income_id'], 'integer'],
            [['date'], 'required'],
            [['date'], 'safe']
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'income_id' => 'Income ID',
            'date' => 'Date',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getIncome()
    {
        return $this->hasOne(Income::className(), ['id' => 'income_id']);
    }

    /**
     * @inheritdoc
     */
    public function afterSave($insert, $changedAttributes)
    {
        parent::afterSave($insert, $changedAttributes);
        if ($this->scenario == self::SCENARIO_CLONE) {
            return;
        }

        // save meta for income pause
        if ($insert) {
            $incomeChange = new IncomeChange();
            $incomeChange->setAttributes([
                'type'      => 'P',
                'income_id' => $this->income_id,
                'user_id'   => Yii::$app->user->identity->id
            ]);
            $incomeChange->save();
        }
    }

    /**
     * @inheritdoc
     */
    public function afterDelete()
    {
        parent::afterDelete();
        if ($this->scenario == self::SCENARIO_CLONE) {
            return;
        }

        // save meta for income continuation
        $incomeChange = new IncomeChange();
        $incomeChange->setAttributes([
            'type'      => 'K',
            'income_id' => $this->income_id,
            'user_id'   => Yii::$app->user->identity->id
        ]);
        $incomeChange->save();
    }
}
