<?php

namespace backend\models\db;


/**
 * This is the model class for table "invoice_items".
 *
 * @property integer $id
 * @property integer $invoice_id
 * @property integer $user_plan_id
 * @property string $date_start
 * @property string $date_end
 * @property string $description
 * @property string $amount
 *
 * @property Invoice $invoice
 */
class InvoiceItem extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'invoice_items';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['invoice_id', 'date_start', 'date_end', 'description'], 'required'],
            [['invoice_id', 'user_plan_id'], 'integer'],
            [['date_start', 'date_end'], 'safe'],
            [['amount'], 'number'],
            [['description'], 'string', 'max' => 255]
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'invoice_id' => 'Invoice ID',
            'user_plan_id' => 'User Plan ID',
            'date_start' => 'Date Start',
            'date_end' => 'Date End',
            'description' => 'Description',
            'amount' => 'Amount',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getInvoice()
    {
        return $this->hasOne(Invoice::className(), ['id' => 'invoice_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getUserPlan()
    {
        return $this->hasOne(UserPlan::className(), ['id' => 'user_plan_id']);
    }
}
