<?php

namespace backend\models\db;


/**
 * This is the model class for table "jar_changes".
 *
 * @property integer $id
 * @property integer $jar_id
 * @property string $type
 * @property string $time
 * @property string $user_id
 *
 * @property JarChangeMeta[] $jarChangeMetas
 * @property Jar $jar
 */
class JarChange extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'jar_changes';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['jar_id'], 'integer'],
            [['time'], 'safe'],
            [['type'], 'string', 'max' => 1],
            [['user_id'], 'integer']
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'jar_id' => 'Jar ID',
            'type' => 'Type',
            'time' => 'Time',
            'user_id' => 'User ID'
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getJarChangeMetas()
    {
        return $this->hasMany(JarChangeMeta::className(), ['jar_change_id' => 'id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getJar()
    {
        return $this->hasOne(Jar::className(), ['id' => 'jar_id']);
    }


    public function getUser()
    {
        return $this->hasOne(User::className(), ['id' => 'user_id']);
    }
}
