<?php

namespace backend\models\db;


/**
 * This is the model class for table "jar_change_meta".
 *
 * @property integer $id
 * @property integer $jar_change_id
 * @property string $key
 * @property string $value
 *
 * @property JarChange $jarChange
 */
class JarChangeMeta extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'jar_change_meta';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['jar_change_id'], 'integer'],
            [['key'], 'string', 'max' => 40],
            [['value'], 'string', 'max' => 45]
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'jar_change_id' => 'Jar Change ID',
            'key' => 'Key',
            'value' => 'Value',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getJarChange()
    {
        return $this->hasOne(JarChange::className(), ['id' => 'jar_change_id']);
    }
}
