<?php

namespace backend\models\db;


/**
 * This is the model class for table "jar_types".
 *
 * @property integer $id
 * @property string $name
 *
 * @property Jar[] $jars
 */
class JarType extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'jar_types';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['name'], 'required'],
            [['name'], 'string', 'max' => 30]
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'name' => 'Name',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getJars()
    {
        return $this->hasMany(Jar::className(), ['jar_type_id' => 'id']);
    }
}
