<?php

namespace backend\models\db;


/**
 * This is the model class for table "note_attachments".
 *
 * @property integer $id
 * @property integer $note_id
 * @property string $name
 * @property string $path
 *
 * @property Note $note
 */
class NoteAttachment extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'note_attachments';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['note_id'], 'integer'],
            [['name'], 'string'],
            [['path'], 'string', 'max' => 200]
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'note_id' => 'Note ID',
            'name' => 'Name',
            'path' => 'Path',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getNote()
    {
        return $this->hasOne(Note::className(), ['id' => 'note_id']);
    }
}
