<?php

namespace backend\models\db;


/**
 * This is the model class for table "notifications".
 *
 * @property integer $id
 * @property integer $user_id
 * @property integer $notification_template_name
 * @property string $subject
 * @property string $content
 * @property integer $read
 * @property integer $archived
 *
 * @property NotificationTemplate $notificationTemplate
 * @property User $user
 */
class Notification extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'notifications';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['user_id', 'read', 'archived'], 'integer'],
            [['content', 'notification_template_name'], 'required'],
            [['subject', 'content', 'notification_template_name'], 'string'],
            [['created_at'], 'safe']
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'user_id' => 'User ID',
            'notification_template_name' => 'Notification Template Name',
            'subject' => 'Subject',
            'content' => 'Content',
            'created_at' => 'Created At',
            'read' => 'Read',
            'archived' => 'Archived',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getNotificationTemplate()
    {
        return $this->hasOne(NotificationTemplate::className(), ['name' => 'notification_template_name']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getUser()
    {
        return $this->hasOne(User::className(), ['id' => 'user_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getNotificationReminders()
    {
        return $this->hasMany(NotificationReminder::className(), ['notification_id' => 'id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getNotificationData()
    {
        return $this->hasOne(NotificationData::className(), ['notification_id' => 'id']);
    }


    /**
     * Get content to store for a notification. Populates the template
     * @param string $name Name of the notification template.
     * @param array $params List of params for tempalate population.
     * @param object $user
     * @return boolean
     */
    public static function getNotificationContent($name, $params, $user)
    {
        $template = NotificationTemplate::findOne(['name' => $name]);
        if (!$template) {
            return false;
        }

        $replacements = [];
        if (is_object($user)) {
            $user = $user->toArray();
        }
        $data = $params + $user;
        foreach($data as $key => $d) {
            $replacements['%' . $key . '%'] =  $d;
        }
        $content = strtr($template->content, $replacements);
        return [
            'content' => $content,
            'subject' => $template->subject
        ];
    }


}
