<?php

namespace backend\models\db;

use Yii;


/**
 * This is the model class for table "time_formats".
 *
 * @property integer $id
 * @property string $format
 * @property string $name
 */
class TimeFormat extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'time_formats';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['format', 'name'], 'required'],
            [['format'], 'string', 'max' => 12],
            [['name'], 'string', 'max' => 25]
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'format' => 'Format',
            'name' => 'Name',
        ];
    }

    /**
     * Returns time format for the selected time format record
     * @param null|integer $metaTimeFormatId
     * @return string
     */
    public static function getTimeFormat($metaTimeFormatId = null)
    {
        $timeFormatId = $metaTimeFormatId && is_numeric($metaTimeFormatId) ?
            $metaTimeFormatId : Yii::$app->params['defaultTimeFormatId'];
        $timeFormat = TimeFormat::findOne(['id' => $timeFormatId]);

        if (!$timeFormat) {

            $timeFormat = TimeFormat::findOne(['id' => 1]);

        }

        return $timeFormat->format;
    }
}
