<?php

namespace backend\models\db;

use Yii;


/**
 * This is the model class for table "time_zones".
 *
 * @property integer $id
 * @property string $name
 * @property string $code
 */
class TimeZone extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'time_zones';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['code', 'name'], 'required'],
            [['code'], 'string', 'max' => 30],
            [['name'], 'string', 'max' => 50]
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'code' => 'Code',
            'name' => 'Name',
        ];
    }

    /**
     * Returns Time Zone for the selected timezone
     * @param null $metaTimeZoneId
     * @return null|static
     */
    public static function getTimeZone($metaTimeZoneId = null)
    {
        $timeZoneId = $metaTimeZoneId && is_numeric($metaTimeZoneId) ?
            $metaTimeZoneId : Yii::$app->params['defaultTimeZoneId'];
        $timeZone = TimeZone::findOne(['id' => $timeZoneId]);

        if (!$timeZone) {
            $timeZone = TimeZone::findOne(['id' => 1]);
        }

        return $timeZone;
    }

    /**
     * Returns Time Zone code for the selected timezone
     * @param null|integer $metaTimeZoneId
     * @return string
     */
    public static function getTimeZoneCode($metaTimeZoneId = null)
    {
        $timeZone = self::getTimeZone($metaTimeZoneId);
        return $timeZone->code;
    }
}
