<?php

namespace backend\models\db;


/**
 * This is the model class for table "transfer_change_meta".
 *
 * @property integer $id
 * @property integer $transfer_change_id
 * @property string $key
 * @property string $value
 *
 * @property ExpenseChange $transferChange
 */
class TransferChangeMeta extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'transfer_change_meta';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['transfer_change_id'], 'integer'],
            [['key'], 'string', 'max' => 40],
            [['value'], 'safe']
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'transfer_change_id' => 'Transfer Change ID',
            'key' => 'Key',
            'value' => 'Value',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getTransferChange()
    {
        return $this->hasOne(ExpenseChange::className(), ['id' => 'transfer_change_id']);
    }
}
