<?php

namespace backend\models\db;
use backend\components\helpers\Formatter;


/**
 * This is the model class for table "update".
 *
 * @property integer $id
 * @property string $type
 * @property string $start_time
 * @property string $end_time
 * @property string $step
 */
class Update extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'updates';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['start_time', 'end_time'], 'safe'],
            [['step', 'type'], 'required'],
            [['step', 'type'], 'string', 'max' => 30],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'start_time' => 'Start Time',
            'end_time' => 'End Time',
            'step' => 'Step',
        ];
    }

    /**
     * Returns all times/dates when the CRON didn't finish correctly
     * (Update entry missing or the result is not marked with "done")
     * *in the last 24 hours*
     * @param string $type
     * @param bool $excludeCurrent
     * @param bool $format
     * @return array
     */
    public static function getTimesToProcess($type, $excludeCurrent = false, $format = false, $maxHours = 24)
    {
        $times = [];
        $nowTime = strtotime(date('Y-m-d H:00:00'));
        $curTime = $excludeCurrent ?
            strtotime('-1 hour', $nowTime) :
            $nowTime;
        for ($i = 0; $i < $maxHours; $i++) {
            $update = Update::find()->where(['and',
                ['type' => $type],
                ['like', 'start_time', Formatter::localDatetimeToUtcDatetime($curTime)]
            ])->one();
            if ((!$update || $update->step != 'done') && array_search($curTime, $times) === false) {
                array_unshift(
                    $times,
                    $format ?
                        Formatter::localDatetimeToUtcDatetime($curTime) :
                        $curTime
                );
                if ($update) {
                    $update->delete();
                }
            }
            $curTime = strtotime('-1 hour', $curTime);
        }
        return $times;
    }

    /**
     * Gets the list of all failed crons of given type
     * @param $type
     * @return array
     */
    public static function getFailedCrons($type)
    {
        return Update::find()->where(['and',
            ['type' => $type],
            ['!=', 'step', 'done']
        ])->all();
    }
}
