<?php

namespace backend\models\db;

use Yii;

/**
 * This is the model class for table "user_changes".
 *
 * @property integer $id
 * @property integer $user_record_id
 * @property string $time
 * @property string $type
 * @property integer $user_id
 *
 * @property UserChangeMeta[] $userChangeMetas
 * @property User $user
 * @property User $userRecord
 */
class UserChange extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'user_changes';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['user_record_id', 'user_id'], 'required'],
            [['user_record_id', 'user_id'], 'integer'],
            [['time'], 'safe'],
            [['type'], 'string', 'max' => 1],
            [['user_id'], 'exist', 'skipOnError' => true, 'targetClass' => User::className(), 'targetAttribute' => ['user_id' => 'id']],
            [['user_record_id'], 'exist', 'skipOnError' => true, 'targetClass' => User::className(), 'targetAttribute' => ['user_record_id' => 'id']],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'user_record_id' => 'User Record ID',
            'time' => 'Time',
            'type' => 'Type',
            'user_id' => 'User ID',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getUserChangeMetas()
    {
        return $this->hasMany(UserChangeMeta::className(), ['user_change_id' => 'id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getUser()
    {
        return $this->hasOne(User::className(), ['id' => 'user_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getUserRecord()
    {
        return $this->hasOne(User::className(), ['id' => 'user_record_id']);
    }
}
