<?php

namespace backend\models\db;


/**
 * This is the model class for table "user_plan_features".
 *
 * @property integer $id
 * @property string $name
 * @property integer $order
 * @property integer $archived
 *
 * @property UserPlanDetail[] $userPlanDetails
 */
class UserPlanFeature extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'user_plan_features';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['name'], 'required'],
            [['order', 'archived'], 'integer'],
            [['name'], 'string', 'max' => 64]
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'name' => 'Name',
            'order' => 'Order',
            'archived' => 'Archived',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getUserPlanDetails()
    {
        return $this->hasMany(UserPlanDetail::className(), ['user_plan_feature_id' => 'id']);
    }
}
