<?php

namespace backend\models\db;


/**
 * This is the model class for table "user_plan_type_durations".
 *
 * @property integer $id
 * @property integer $user_plan_type_id
 * @property integer $months
 *
 * @property UserPlanType $userPlanType
 */
class UserPlanTypeDuration extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'user_plan_type_durations';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['user_plan_type_id', 'months'], 'integer']
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'user_plan_type_id' => 'User Plan Type ID',
            'months' => 'Months',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getUserPlanType()
    {
        return $this->hasOne(UserPlanType::className(), ['id' => 'user_plan_type_id']);
    }
}
