<?php

namespace backend\models\db;


/**
 * This is the model class for table "user_registrations".
 *
 * @property integer $id
 * @property integer $user_id
 * @property string $time
 * @property string $auth_token
 * @property string $auth_time
 *
 * @property User $user
 */
class UserRegistration extends \yii\db\ActiveRecord {

    /**
     * @inheritdoc
     */
    public static function tableName() {
        return 'user_registrations';
    }

    /**
     * @inheritdoc
     */
    public function rules() {
        return [
            [['user_id'], 'integer'],
            [['time', 'auth_time'], 'safe'],
            [['auth_token'], 'string', 'max' => 100]
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels() {
        return [
            'id' => 'ID',
            'user_id' => 'User ID',
            'time' => 'Time',
            'auth_token' => 'Auth Token',
            'auth_time' => 'Auth Time',
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getUser() {
        return $this->hasOne(User::className(), ['id' => 'user_id']);
    }

}
