<?php

namespace backend\models\form;

use backend\models\db\Jar;

/**
 * New jar form
 */
class EditJar extends \yii\base\Model {

    public $name;
    public $jar_id; // used for validation
    public $budget_id; // used for validation

    public function rules() {

        // validate input
        $validationRules = [
            ['name', 'required'],
            ['name', 'string', 'min' => 3],
            ['name', 'jarNameUnique'],
            ['name', 'jarNameNotSpecial']
        ];

        // sanitize
        $filterRules = [
            [array_keys($this->getAttributes()), 'filter', 'filter' => 'strip_tags'],
            [array_keys($this->getAttributes()), 'filter', 'filter' => 'trim']
        ];

        return array_merge($validationRules, $filterRules);

    }


    /**
     * Check whether jar name is unique.
     */
    public function jarNameUnique() {

        $jar = Jar::find()
            ->where(['budget_id' => $this->budget_id])
            ->andWhere(['name' => $this->name])
            ->andWhere(['!=', 'id', $this->jar_id])
            ->one();

        if ($jar) {

            $this->addError($attribute, 'Please enter a unique jar name.');

        }

    }


    /**
     * Check if jar name is not a special, forbidden name
     */
    public function jarNameNotSpecial() {

        $forbiddenNames = [
            'debts',
            'interest'
        ];

        if (in_array(strtolower($this->name), $forbiddenNames)) {

            $this->addError($this->name, "\"{$this->name}\" is not a valid jar name.");

        }

    }

}
