<?php

namespace backend\models\form;

use backend\components\validators\Currency;
use backend\models\db\Account;
use backend\models\db\Debt;

/**
 * New eoms summary debt amount form
 */
class EditSummaryCcDebtAmount extends \yii\base\Model
{
    public $budget_id = -1;
    public $debt_id;
    public $account_id;

    public $starting_balance;
    public $payments_made;
    public $money_spent;
    public $adjustment_amount;
    public $current_balance;
    public $actual_balance;
    public $archived;

    public function rules()
    {
        // validate input
        $validationRules = [
            [['actual_balance', 'current_balance'], 'required'],
            [['starting_balance', 'current_balance', 'payments_made', 'money_spent', 'adjustment_amount'], 'number'],
            ['actual_balance', Currency::className()],
            [['debt_id', 'account_id'], 'integer'],
            ['debt_id', 'debtIdValid'],
            ['account_id', 'accountIdValid']
        ];
        // sanitize
        $filterRules = [
            [array_keys($this->getAttributes()), 'filter', 'filter' => 'strip_tags'],
            [array_keys($this->getAttributes()), 'filter', 'filter' => 'trim'],
            ['actual_balance', 'filter', 'filter' => ['backend\components\helpers\Formatter', 'currencyToDecimal']]
        ];

        return array_merge($validationRules, $filterRules);
    }

    /**
     * Check if the debt ID can be accessed by this user
     */
    public function debtIdValid($attribute)
    {
        $debt = Debt::findOne([
            'budget_id' => $this->budget_id,
            'id' => $this->{$attribute}
        ]);
        if (!$debt) {
            $this->addError($attribute, 'Invalid debt ID.');
        }
    }

    /**
     * Check if the account ID can be accessed by this user
     */
    public function accountIdValid($attribute)
    {
        $account = Account::findOne([
            'budget_id' => $this->budget_id,
            'id' => $this->{$attribute}
        ]);
        if ($this->{$attribute} && !$account) {
            $this->addError($attribute, 'Invalid account ID.');
        }
    }
}
