<?php

namespace backend\models\form;


/**
 * New expense form
 */
class PopulateDb extends \yii\base\Model {

    public $budget_id;
    public $jar_id;
    public $debt_id;
    public $account_id;
    public $account_2_id;
    public $update_expenses;
    public $update_debts;
    public $update_incomes;
    public $update_transfers;
    public $day;
    public $month;
    public $year;

    public function __construct() {

        $this->day = date('d');
        $this->month = date('n');
        $this->year = date('Y');

    }

    public function rules() {

        // validate input
        $validationRules = [
            ['budget_id', 'integer'],
            ['budget_id', 'required'],
            ['jar_id', 'integer'],
            ['jar_id', 'required'],
            ['debt_id', 'integer'],
            ['debt_id', 'required'],
            ['account_id', 'integer'],
            ['account_id', 'required'],
            ['account_2_id', 'integer'],
            ['account_2_id', 'required'],
            ['update_expenses', 'number', 'max' => 1],
            ['update_debts', 'number', 'max' => 1],
            ['day', 'integer', 'max' => 31],
            ['month', 'integer', 'max' => 12],
            ['year', 'integer']
        ];

        // sanitize
        $filterRules = [
            [array_keys($this->getAttributes()), 'filter', 'filter' => 'strip_tags'],
            [array_keys($this->getAttributes()), 'filter', 'filter' => 'trim']
        ];

        return array_merge($validationRules, $filterRules);

    }

}
