<?php

namespace backend\models\form;

use backend\components\validators\Currency;
use backend\models\db\Expense;
use backend\models\db\Jar;
use backend\models\form\common\DateField;

/**
 * New jar form
 */
class TransactionEntry extends \yii\base\Model
{
    use DateField;

    public $generate;
    public $amount;
    public $date;
    public $expense_id;
    public $budget_id;


    public function rules() {

        // validate input
        $validationRules = [
            ['amount', 'required', 'when' => function($model) {
                return $model->generate;
            }, 'whenClient' => 'function(field) {
                var checkboxId = field.id.replace(\'amount\', \'generate\');
                return $(\'#\' + checkboxId).is(\':checked\');
            }'],
            ['amount', Currency::className(), 'min' => '0.01'],
            ['generate', 'integer', 'min' => 0, 'max' => 1],
            ['expense_id', 'required'],
            ['expense_id', 'integer'],
            ['expense_id', 'expenseIdValid'],
            ['date', 'required'],
            ['date', 'dateValid'],
            ['budget_id', 'integer']
        ];

        // sanitize
        $filterRules = [
//            [array_keys($this->getAttributes()), 'filter', 'filter' => 'strip_tags'],
//            [array_keys($this->getAttributes()), 'filter', 'filter' => 'trim']
            ['amount', 'filter', 'filter' => ['backend\components\helpers\Formatter', 'currencyToDecimal']]
        ];

        return array_merge($this->dateRules(), $validationRules, $filterRules);
    }

    public function expenseIdValid($attribute)
    {
        $expense = Expense::findOne(['id' => $this->{$attribute}]);
        $jar = Jar::findOne(['id' => $expense->jar_id,'budget_id' => $this->budget_id]);
        if (!$jar) {
            $this->addError($attribute, 'Invalid expense ID.');
        }
    }

    public function dateValid($attribute)
    {
        $dateTime = strtotime($this->{$attribute});
        $startTime = strtotime(date('Y-m-1'));
        $endTime = strtotime('-1 DAY');
        if (($dateTime > $endTime) || ($dateTime < $startTime)) {
            var_dump(date('Y-m-d', $dateTime));
            var_dump(date('Y-m-d', $startTime));
            var_dump(date('Y-m-d', $endTime));
            $this->addError($attribute, 'Invalid date.');
        }
    }

}
