<?php

namespace backend\models\form\common;

use backend\components\helpers\Formatter;


/**
 * This trait helps with adding custom behavior to all the form classes
 * that support interest_free_end_date field that is formatted according
 * to the user's settings
 * @package backend\models\form\common
 */
trait InterestFreeEndDateField
{
    public function interestFreeEndDateRules()
    {
        return [
            ['formattedInterestFreeEndDate', 'safe']
        ];
    }

    public function getFormattedInterestFreeEndDate()
    {
        return $this->interest_free_end_date ? Formatter::date($this->interest_free_end_date) : null;
    }

    public function setFormattedInterestFreeEndDate($date)
    {
        $this->interest_free_end_date = $date;
    }
}