<?php

namespace backend\models\form\common;

use backend\components\helpers\Formatter;


/**
 * This trait helps with adding custom behavior to all the form classes
 * that support date field that is formatted according to the user's settings
 * @package backend\models\form\common
 */
trait NextDueDateField
{
    public function nextDueDateRules()
    {
        return [
            ['formattedNextDueDate', 'safe']
        ];
    }

    public function getFormattedNextDueDate()
    {
        return $this->next_due_date ? Formatter::date($this->next_due_date) : null;
    }

    public function setFormattedNextDueDate($date)
    {
        $this->next_due_date = $date;
    }
}