<?php

namespace backend\models\form\common;

use backend\components\helpers\Formatter;


/**
 * This trait helps with adding custom behavior to all the form classes
 * that support date field that is formatted according to the user's settings
 * @package backend\models\form\common
 */
trait StartDateField
{
    public function startDateRules()
    {
        return [
            ['formattedStartDate', 'safe']
        ];
    }

    public function getFormattedStartDate()
    {
        return $this->startDate ? Formatter::date($this->startDate) : null;
    }

    public function setFormattedStartDate($date)
    {
        $this->startDate = $date;
    }
}